#include <amxmodx>
#include <umitem>
#include <engine>
#include <cstrike>

#define Shoot_Delay	3.0

new PLUGIN_NAME[] 	= "UM Item: Scout Auto Shoot"
new PLUGIN_AUTHOR[] 	= "Cheap_Suit"
new PLUGIN_VERSION[] 	= "1.1"

new Float:g_Delay[33]
new bool:g_sas[33]
public plugin_init() 
{
	register_plugin(PLUGIN_NAME, PLUGIN_VERSION, PLUGIN_AUTHOR)
	register_item("Scout Auto Shoot", "Only works with a scout", 3100)
	register_event("ResetHUD", "Event_ResetHUD", "be")
	register_event("DeathMsg", "Event_DeathMsg", "a")
	
}

public client_connect(id) {
	g_sas[id] = false
}

public Event_ResetHUD(id)
{
	if(!is_user_connected(id) || !is_user_alive(id)) {
		return PLUGIN_CONTINUE
	}
	
	if(g_sas[id]) 
	{
		if(!task_exists(id)) {
			set_task(0.01, "scout_loop", id, _, _, "b")
		}
	}
	return PLUGIN_CONTINUE
}

public Event_DeathMsg() 
{
	if(task_exists(read_data(2))) {
		remove_task(read_data(2))
	}
}

public Enable_Item(id) 
{
	g_sas[id] = true
	set_task(0.01, "scout_loop", id, _, _, "b")
}

public Disable_Item(id) 
{
	g_sas[id] = false
	if(task_exists(id)) {
		remove_task(id)
	}
}

public scout_loop(id)
{
	if(!is_user_connected(id) || !is_user_alive(id) || !g_sas[id]) 
	{
		if(task_exists(id)) {
			remove_task(id)
		}
		return PLUGIN_CONTINUE
	}

	new clip, ammo, weapon = get_user_weapon(id, clip, ammo)
	if(weapon == CSW_SCOUT)
	{
		if(clip <= 0) {
			return PLUGIN_CONTINUE
		}
			
		new target, body
		get_user_aiming(id, target, body)
		new ateam = get_user_team(target)
		new bteam = get_user_team(id)
			
		if(target < 1 || !is_user_alive(target)) {
			return PLUGIN_CONTINUE
		}
		
		if(ateam == bteam) {
			return PLUGIN_CONTINUE
		}
		
		if((g_Delay[id] + Shoot_Delay) < get_gametime())
		{
			client_cmd(id, "+attack")
			client_cmd(id, "wait")
			client_cmd(id, "-attack")
			client_cmd(id, "wait")
						
			g_Delay[id] = get_gametime()
		}
	}
	return PLUGIN_CONTINUE
}
